/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockLaunchExplosion
extends Explosion {
    private final float size;
    private final Level world;
    private final double x;
    private final double y;
    private final double z;
    private final Explosion.BlockInteraction mode;

    public BlockLaunchExplosion(Level world, Mob entity, double x, double y, double z, float size) {
        this(world, entity, x, y, z, size, Explosion.BlockInteraction.DESTROY);
    }

    public BlockLaunchExplosion(Level world, Mob entity, double x, double y, double z, float size, Explosion.BlockInteraction mode) {
        this(world, entity, null, x, y, z, size, mode);
    }

    public BlockLaunchExplosion(Level world, Mob entity, DamageSource source, double x, double y, double z, float size, Explosion.BlockInteraction mode) {
        super(world, (Entity)entity, source, null, x, y, z, size, false, mode);
        this.world = world;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.mode = mode;
    }

    private static void handleExplosionDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> dropPositionArray, ItemStack stack, BlockPos pos) {
        int i = dropPositionArray.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)dropPositionArray.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)stack)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)stack, (int)16);
            dropPositionArray.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!stack.m_41619_()) continue;
            return;
        }
        dropPositionArray.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public void m_46075_(boolean spawnParticles) {
        boolean flag;
        if (this.world.f_46443_) {
            this.world.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.world.f_46441_.m_188501_() - this.world.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.mode != Explosion.BlockInteraction.NONE;
        if (spawnParticles) {
            if (!(this.size < 2.0f) && flag) {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.m_46081_(), ThreadLocalRandom.current());
            for (BlockPos blockpos : this.m_46081_()) {
                BlockState blockstate = this.world.m_8055_(blockpos);
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.world.m_46473_().m_6180_("explosion_blocks");
                Vec3 Vector3d = new Vec3(this.x, this.y, this.z);
                blockstate.onBlockExploded(this.world, blockpos, (Explosion)this);
                FallingBlockEntity fallingBlockEntity = new FallingBlockEntity(EntityType.f_20450_, this.world);
                fallingBlockEntity.m_31959_(blockpos1);
                fallingBlockEntity.m_6034_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5);
                double d5 = fallingBlockEntity.m_20185_() - this.x;
                double d7 = fallingBlockEntity.m_20188_() - this.y;
                double d9 = fallingBlockEntity.m_20189_() - this.z;
                float f3 = this.size * 2.0f;
                double d12 = Math.sqrt(fallingBlockEntity.m_20238_(Vector3d)) / (double)f3;
                double d14 = BlockLaunchExplosion.m_46064_((Vec3)Vector3d, (Entity)fallingBlockEntity);
                double d11 = (1.0 - d12) * d14;
                fallingBlockEntity.m_20256_(fallingBlockEntity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
                this.world.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.world, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
    }
}

