/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.ClientProxy;
import com.github.alexthe666.iceandfire.client.IafKeybindRegistry;
import com.github.alexthe666.iceandfire.client.gui.IceAndFireMainMenu;
import com.github.alexthe666.iceandfire.client.particle.CockatriceBeamRender;
import com.github.alexthe666.iceandfire.client.render.entity.RenderChain;
import com.github.alexthe666.iceandfire.client.render.tile.RenderFrozenState;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.props.FrozenProperties;
import com.github.alexthe666.iceandfire.entity.props.MiscProperties;
import com.github.alexthe666.iceandfire.entity.props.SirenProperties;
import com.github.alexthe666.iceandfire.entity.util.ICustomMoveController;
import com.github.alexthe666.iceandfire.enums.EnumParticles;
import com.github.alexthe666.iceandfire.item.IafArmorMaterial;
import com.github.alexthe666.iceandfire.message.MessageDragonControl;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.WorldEventContext;
import java.util.List;
import java.util.Random;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="iceandfire", value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation SIREN_SHADER = new ResourceLocation("iceandfire:shaders/post/siren.json");
    private final Random rand = new Random();
    public final boolean AUTO_ADAPT_3RD_PERSON = true;

    private static boolean shouldCancelRender(LivingEntity living) {
        if (living.m_20202_() != null && living.m_20202_() instanceof EntityDragonBase) {
            return ClientProxy.currentDragonRiders.contains(living.m_20148_()) || living == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderWorldLastEvent(@NotNull RenderLevelStageEvent event) {
        WorldEventContext.INSTANCE.renderWorldLastEvent(event);
    }

    @SubscribeEvent
    public void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_20202_() != null && player.m_20202_() instanceof EntityDragonBase) {
            int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
            float scale = ((EntityDragonBase)player.m_20202_()).getRenderSize() / 3.0f;
            if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK || Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_FRONT) {
                if (currentView == 1) {
                    event.getCamera().m_90568_(-event.getCamera().m_90566_((double)(scale * 1.2f)), 0.0, 0.0);
                } else if (currentView == 2) {
                    event.getCamera().m_90568_(-event.getCamera().m_90566_((double)(scale * 3.0f)), 0.0, 0.0);
                } else if (currentView == 3) {
                    event.getCamera().m_90568_(-event.getCamera().m_90566_((double)(scale * 5.0f)), 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        Object moveController;
        Minecraft mc = Minecraft.m_91087_();
        if (event.getEntity() instanceof ICustomMoveController) {
            LivingEntity entity = event.getEntity();
            moveController = (ICustomMoveController)event.getEntity();
            if (entity.m_20202_() != null && entity.m_20202_() == mc.f_91074_) {
                byte previousState = moveController.getControlState();
                moveController.dismount(mc.f_91066_.f_92090_.m_90857_());
                byte controlState = moveController.getControlState();
                if (controlState != previousState) {
                    IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(entity.m_19879_(), controlState, entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
                }
            }
        }
        if ((moveController = event.getEntity()) instanceof Player) {
            Player player = (Player)moveController;
            if (player.f_19853_.f_46443_ && player.m_20202_() instanceof ICustomMoveController) {
                Entity entity = player.m_20202_();
                ICustomMoveController moveController2 = (ICustomMoveController)player.m_20202_();
                byte previousState = moveController2.getControlState();
                moveController2.up(mc.f_91066_.f_92089_.m_90857_());
                moveController2.down(IafKeybindRegistry.dragon_down.m_90857_());
                moveController2.attack(IafKeybindRegistry.dragon_strike.m_90857_());
                moveController2.dismount(mc.f_91066_.f_92090_.m_90857_());
                moveController2.strike(IafKeybindRegistry.dragon_fireAttack.m_90857_());
                byte controlState = moveController2.getControlState();
                if (controlState != previousState) {
                    IceAndFire.NETWORK_WRAPPER.sendToServer((Object)new MessageDragonControl(entity.m_19879_(), controlState, entity.m_20185_(), entity.m_20186_(), entity.m_20189_()));
                }
            }
            if (player.f_19853_.f_46443_ && IafKeybindRegistry.dragon_change_view.m_90857_()) {
                int currentView = IceAndFire.PROXY.getDragon3rdPersonView();
                currentView = currentView + 1 > 3 ? 0 : ++currentView;
                IceAndFire.PROXY.setDragon3rdPersonView(currentView);
            }
            if (player.f_19853_.f_46443_) {
                GameRenderer renderer = Minecraft.m_91087_().f_91063_;
                EntitySiren siren = SirenProperties.getSiren((LivingEntity)player);
                if (IafConfig.sirenShader && siren == null && renderer != null && renderer.m_109149_() != null && SIREN_SHADER.toString().equals(renderer.m_109149_().m_110022_())) {
                    renderer.m_109086_();
                }
                if (siren == null) {
                    return;
                }
                boolean isCharmed = SirenProperties.isCharmed((LivingEntity)player);
                if (IafConfig.sirenShader && !isCharmed && renderer != null && renderer.m_109149_() != null && SIREN_SHADER.toString().equals(renderer.m_109149_().m_110022_())) {
                    renderer.m_109086_();
                }
                if (isCharmed) {
                    if (player.f_19853_.f_46443_ && this.rand.nextInt(40) == 0) {
                        IceAndFire.PROXY.spawnParticle(EnumParticles.Siren_Appearance, player.m_20185_(), player.m_20186_(), player.m_20189_(), siren.getHairColor(), 0.0, 0.0);
                    }
                    if (IafConfig.sirenShader && renderer.m_109149_() == null) {
                        renderer.m_109128_(SIREN_SHADER);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPreRenderLiving(RenderLivingEvent.Pre event) {
        if (ClientEvents.shouldCancelRender(event.getEntity())) {
            event.setCanceled(true);
        }
        block6: for (EquipmentSlot slot : List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET)) {
            ArmorItem armorStack;
            ItemStack stack = event.getEntity().m_6844_(slot);
            Item item = stack.m_41720_();
            if (!(item instanceof ArmorItem) || !((armorStack = (ArmorItem)item).m_40401_() instanceof IafArmorMaterial)) continue;
            switch (slot) {
                case HEAD: {
                    EntityModel entityModel = event.getRenderer().m_7200_();
                    if (!(entityModel instanceof HumanoidModel)) continue block6;
                    HumanoidModel humanoidModel = (HumanoidModel)entityModel;
                    humanoidModel.f_102809_.f_104207_ = false;
                    break;
                }
                case CHEST: {
                    EntityModel entityModel = event.getRenderer().m_7200_();
                    if (!(entityModel instanceof PlayerModel)) continue block6;
                    PlayerModel playerModel = (PlayerModel)entityModel;
                    playerModel.f_103378_.f_104207_ = false;
                    playerModel.f_103374_.f_104207_ = false;
                    playerModel.f_103375_.f_104207_ = false;
                    break;
                }
                case LEGS: {
                    EntityModel entityModel = event.getRenderer().m_7200_();
                    if (!(entityModel instanceof PlayerModel)) continue block6;
                    PlayerModel playerModel = (PlayerModel)entityModel;
                    playerModel.f_103376_.f_104207_ = false;
                    playerModel.f_103377_.f_104207_ = false;
                    break;
                }
                case FEET: {
                    EntityModel entityModel = event.getRenderer().m_7200_();
                    if (!(entityModel instanceof PlayerModel)) break;
                    PlayerModel playerModel = (PlayerModel)entityModel;
                    playerModel.f_102814_.f_104207_ = false;
                    playerModel.f_102813_.f_104207_ = false;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPostRenderLiving(RenderLivingEvent.Post event) {
        if (ClientEvents.shouldCancelRender(event.getEntity())) {
            event.setCanceled(true);
        }
        LivingEntity entity = event.getEntity();
        MiscProperties.getTargetedBy(entity).forEach(caster -> CockatriceBeamRender.render((Entity)entity, (Entity)caster, event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick()));
        if (FrozenProperties.isFrozen(event.getEntity())) {
            RenderFrozenState.render(event.getEntity(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
        RenderChain.render(entity, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
    }

    @SubscribeEvent
    public void onGuiOpened(ScreenEvent.Opening event) {
        if (IafConfig.customMainMenu && event.getScreen() instanceof TitleScreen && !(event.getScreen() instanceof IceAndFireMainMenu)) {
            event.setNewScreen((Screen)new IceAndFireMainMenu());
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        EntityDragonBase dragon;
        if (event.getEntityBeingMounted() instanceof EntityDragonBase && event.getLevel().f_46443_ && event.getEntityMounting() == Minecraft.m_91087_().f_91074_ && (dragon = (EntityDragonBase)event.getEntityBeingMounted()).m_21824_() && dragon.m_21830_((LivingEntity)Minecraft.m_91087_().f_91074_)) {
            IceAndFire.PROXY.setDragon3rdPersonView(2);
            if (IafConfig.dragonAuto3rdPerson) {
                if (event.isDismounting()) {
                    Minecraft.m_91087_().f_91066_.m_92157_(CameraType.values()[IceAndFire.PROXY.getPreviousViewType()]);
                } else {
                    IceAndFire.PROXY.setPreviousViewType(Minecraft.m_91087_().f_91066_.m_92176_().ordinal());
                    Minecraft.m_91087_().f_91066_.m_92157_(CameraType.values()[1]);
                }
            }
        }
    }
}

