/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.base.elements;

import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.elements.CommonBarElement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

public class CommonFluidBarElement
extends CommonBarElement {
    FluidStack FLUID;
    int CAPACITY;
    boolean IGNORE_CAPACITY;

    public CommonFluidBarElement(FluidStack fluidStack, int capacity, boolean ignoreCapacity) {
        super(fluidStack.getAmount(), capacity, (Component)Component.m_237119_(), JadeHelper.getColorForFluid(fluidStack));
        this.FLUID = fluidStack;
        this.CAPACITY = capacity;
        this.IGNORE_CAPACITY = ignoreCapacity;
    }

    public FluidStack getFluid() {
        return this.FLUID;
    }

    public boolean ignoreCapacity() {
        return this.IGNORE_CAPACITY;
    }

    @Override
    public int getMax() {
        return this.ignoreCapacity() ? this.getFluid().getAmount() : super.getMax();
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag.m_128365_("fluid", (Tag)this.FLUID.writeToNBT(new CompoundTag()));
        tag.m_128405_("capacity", this.CAPACITY);
        tag.m_128379_("ignoreCapacity", this.IGNORE_CAPACITY);
        return tag;
    }

    public static CommonFluidBarElement load(CompoundTag tag) {
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("fluid"));
        int capacity = tag.m_128451_("capacity");
        boolean ignoreCapacity = tag.m_128471_("ignoreCapacity");
        return new CommonFluidBarElement(fluid, capacity, ignoreCapacity);
    }

    @Override
    public String getTagId() {
        return "jade_addon_fluid";
    }
}

