/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.api.energy.tile.IEnergyTile;
import ic2.api.items.electric.ElectricItem;
import ic2.core.block.base.tiles.impls.BaseChargingBenchTileEntity;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.EnergyContainer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ChargingBenchInfo
implements IInfoProvider {
    public static final ChargingBenchInfo THIS = new ChargingBenchInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof BaseChargingBenchTileEntity) {
            BaseChargingBenchTileEntity bench = (BaseChargingBenchTileEntity)blockEntity;
            helper.maxIn(bench.getMaxInput());
            int missingEnergy = 0;
            for (int i = 0; i < 16; ++i) {
                ItemStack toCharge = bench.getStackInSlot(i);
                if (toCharge.m_41619_()) continue;
                missingEnergy += ElectricItem.MANAGER.getCapacity(toCharge) - ElectricItem.MANAGER.getCharge(toCharge);
            }
            int benchAverageOut = bench.getMissingEnergy().getIntValue();
            if (missingEnergy > 0) {
                int i = Math.min(benchAverageOut, missingEnergy);
                helper.text((Component)this.translate("ic2.probe.chargingBench.eta.name", new Object[]{DurationFormatUtils.formatDuration((long)(i <= 0 ? 0L : (long)(missingEnergy / i) * 50L), (String)"HH:mm:ss")}).m_130940_(ChatFormatting.GOLD));
            }
            ItemStack battery = bench.getStackInSlot(16);
            int toDischargeEnergy = ElectricItem.MANAGER.getCharge(battery);
            int transferLimit = ElectricItem.MANAGER.getTransferLimit(battery);
            int maxCapacity = ElectricItem.MANAGER.getCapacity(battery);
            if (toDischargeEnergy > 0) {
                int dischargeEnergy = Math.min(transferLimit, toDischargeEnergy);
                helper.bar(toDischargeEnergy, maxCapacity, (Component)this.translate("ic2.probe.discharging.eta.name", new Object[]{DurationFormatUtils.formatDuration((long)(dischargeEnergy <= 0 ? 0L : (long)(toDischargeEnergy / dischargeEnergy) * 50L), (String)"HH:mm:ss")}).m_130940_(ChatFormatting.WHITE), -16733185);
            }
            EnergyContainer container = EnergyContainer.getContainer((IEnergyTile)bench);
            helper.addAveragesIn(container);
        }
    }
}

