/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers;

import ic2.core.block.base.tiles.BaseElectricTileEntity;
import ic2.core.block.base.tiles.impls.BaseFluxGeneratorTileEntity;
import ic2.core.block.cables.mointor.MonitorTileEntity;
import ic2.core.block.machines.tiles.ev.CrafterTileEntity;
import ic2.core.block.machines.tiles.hv.ElectricEnchanterTileEntity;
import ic2.core.block.machines.tiles.hv.MassFabricatorTileEntity;
import ic2.core.block.machines.tiles.hv.TerraformerTileEntity;
import ic2.core.block.machines.tiles.luv.TeleporterHubTileEntity;
import ic2.core.block.machines.tiles.lv.CropMatronTileEntity;
import ic2.core.block.machines.tiles.lv.MachineBufferTileEntity;
import ic2.core.block.machines.tiles.lv.MachineTankTileEntity;
import ic2.core.block.machines.tiles.lv.MagnetizerTileEntity;
import ic2.core.block.machines.tiles.mv.ChunkloaderTileEntity;
import ic2.core.block.machines.tiles.mv.CropHarvesterTileEntity;
import ic2.core.block.machines.tiles.mv.ReactorPlannerTileEntity;
import ic2.core.block.machines.tiles.mv.TeslaCoilTileEntity;
import ic2.core.utils.math.ColorUtils;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.Formatter;
import ic2.jadeplugin.helpers.TextFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ElectricBlockInfo
implements IInfoProvider {
    public static final ElectricBlockInfo THIS = new ElectricBlockInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof BaseElectricTileEntity) {
            MonitorTileEntity monitor;
            BaseElectricTileEntity baseTile = (BaseElectricTileEntity)blockEntity;
            if (baseTile instanceof ChunkloaderTileEntity) {
                ChunkloaderTileEntity chunkLoader = (ChunkloaderTileEntity)baseTile;
                helper.maxIn(chunkLoader.getMaxInput());
                helper.usage(ChunkloaderTileEntity.POWER_COST[chunkLoader.getRadius()] * (chunkLoader.doesChunkProcessing ? 2 : 1));
                helper.text((Component)this.translate("ic2.probe.chunkloader.radius", new Object[]{this.string(String.valueOf(chunkLoader.getRadius())).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GOLD));
                boolean chunkTicks = chunkLoader.doesChunkProcessing;
                helper.text((Component)this.translate("ic2.probe.chunkloader.ticks", new Object[]{(chunkTicks ? ChatFormatting.GREEN : ChatFormatting.RED) + String.valueOf(chunkTicks)}).m_130940_(ChatFormatting.GOLD));
            }
            if (baseTile instanceof MonitorTileEntity && (monitor = (MonitorTileEntity)baseTile).isMaster()) {
                helper.maxInFromTier(monitor.getTier());
                helper.usage(monitor.isActive() ? Math.max(monitor.width, monitor.height) : 0);
            }
            if (baseTile instanceof CrafterTileEntity) {
                CrafterTileEntity crafter = (CrafterTileEntity)baseTile;
                helper.maxInFromTier(crafter.getTier());
                helper.usage(25);
                helper.defaultText("ic2.probe.crafter.delay", TextFormatter.GREEN.literal("" + crafter.getSpeed()));
                helper.defaultText("ic2.probe.crafter.crafts", TextFormatter.GREEN.literal("" + crafter.getCrafts()));
            }
            if (baseTile instanceof TerraformerTileEntity || baseTile instanceof ReactorPlannerTileEntity || baseTile instanceof BaseFluxGeneratorTileEntity || baseTile instanceof CropHarvesterTileEntity || baseTile instanceof MachineBufferTileEntity || baseTile instanceof MagnetizerTileEntity || baseTile instanceof TeslaCoilTileEntity || baseTile instanceof TeleporterHubTileEntity) {
                helper.maxInFromTier(baseTile.getTier());
            }
            if (baseTile instanceof MachineTankTileEntity) {
                MachineTankTileEntity tank = (MachineTankTileEntity)baseTile;
                helper.maxInFromTier(tank.getTier());
                helper.addTankInfo((BlockEntity)tank);
            }
            if (baseTile instanceof CropMatronTileEntity) {
                CropMatronTileEntity cropmatron = (CropMatronTileEntity)baseTile;
                helper.maxInFromTier(cropmatron.getTier());
                helper.addTankInfo((BlockEntity)cropmatron);
            }
            if (baseTile instanceof ElectricEnchanterTileEntity) {
                ElectricEnchanterTileEntity enchanter = (ElectricEnchanterTileEntity)baseTile;
                helper.maxIn(enchanter.getMaxInput());
                helper.usage(500);
                int storedXP = enchanter.storedExperience;
                int progress = (int)enchanter.getProgress();
                int maxProgress = (int)enchanter.getMaxProgress();
                if (storedXP <= 0) {
                    helper.text((Component)this.translate("ic2.probe.enchanter.missing").m_130940_(ChatFormatting.RED));
                } else {
                    helper.bar(storedXP, 1000, (Component)this.translate("ic2.probe.machine.xp", new Object[]{storedXP}), ColorUtils.GREEN);
                }
                if (progress > 0) {
                    helper.bar(progress, maxProgress, (Component)this.translate("ic2.probe.progress.full.name", new Object[]{progress, maxProgress}).m_130946_("t"), -16733185);
                }
            }
            if (baseTile instanceof MassFabricatorTileEntity) {
                MassFabricatorTileEntity massFab = (MassFabricatorTileEntity)baseTile;
                helper.maxIn(massFab.getMaxInput());
                int progress = (int)massFab.getProgress();
                int maxProgress = (int)massFab.getMaxProgress();
                if (progress > 0) {
                    double finalProgress = (double)((float)progress / massFab.getMaxProgress()) * 100.0;
                    if (finalProgress > 100.0) {
                        finalProgress = 100.0;
                    }
                    helper.bar(progress, maxProgress, (Component)this.translate("ic2.probe.progress.moderate.name", new Object[]{Formatter.THERMAL_GEN.format(finalProgress)}), -4441721);
                }
                if (massFab.getScrap() > 0) {
                    helper.bar(massFab.getScrap(), massFab.getLastScrap() * 2, (Component)this.translate("ic2.probe.matter.amplifier.name", new Object[]{massFab.getScrap()}), -10996205);
                }
            }
        }
    }
}

