/*
 * Decompiled with CFR 0.152.
 */
package ic2.jadeplugin.providers.transport;

import ic2.core.block.transport.item.tubes.FilterTubeTileEntity;
import ic2.core.utils.collection.SynchronizedList;
import ic2.jadeplugin.base.JadeHelper;
import ic2.jadeplugin.base.interfaces.IInfoProvider;
import ic2.jadeplugin.helpers.TextFormatter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FilterTubeInfo
implements IInfoProvider {
    public static final FilterTubeInfo THIS = new FilterTubeInfo();

    @Override
    public void addInfo(JadeHelper helper, BlockEntity blockEntity, Player player) {
        if (blockEntity instanceof FilterTubeTileEntity) {
            FilterTubeTileEntity filterTube = (FilterTubeTileEntity)blockEntity;
            boolean invPriority = filterTube.invPriority;
            helper.text((Component)TextFormatter.GOLD.translate("info.tube.inv.prio", this.status(invPriority)));
            SynchronizedList filterEntries = filterTube.stacks;
            Object2ObjectOpenHashMap mappedFilter = new Object2ObjectOpenHashMap();
            if (!filterEntries.isEmpty()) {
                helper.paddingY(3);
                for (FilterTubeTileEntity.FilterEntry entry : filterEntries) {
                    Component side2 = JadeHelper.getSides(entry.getSides());
                    ((List)mappedFilter.computeIfAbsent((Object)side2, component -> new ArrayList())).add(entry);
                }
                mappedFilter.keySet().forEach(side -> {
                    helper.text((Component)TextFormatter.GOLD.translate("info.tube.filter"));
                    for (FilterTubeTileEntity.FilterEntry entry : (List)mappedFilter.get(side)) {
                        helper.appendPaddingX(2);
                        helper.appendItem(entry.getStack());
                    }
                    helper.appendPaddingX(3);
                    helper.appendText((Component)TextFormatter.WHITE.literal("\u2192 "));
                    helper.appendText((Component)side);
                });
            }
        }
    }
}

