/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler;

import appeng.client.guidebook.compiler.TagCompiler;
import appeng.client.guidebook.compiler.tags.ATagCompiler;
import appeng.client.guidebook.compiler.tags.BreakCompiler;
import appeng.client.guidebook.compiler.tags.CategoryIndexCompiler;
import appeng.client.guidebook.compiler.tags.DivTagCompiler;
import appeng.client.guidebook.compiler.tags.FloatingImageCompiler;
import appeng.client.guidebook.compiler.tags.ItemGridCompiler;
import appeng.client.guidebook.compiler.tags.ItemLinkCompiler;
import appeng.client.guidebook.compiler.tags.RecipeForCompiler;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class TagCompilers {
    private static final Map<String, TagCompiler> handlers = new HashMap<String, TagCompiler>();

    public static void register(String tagName, TagCompiler handler) {
        if (handlers.containsKey(tagName = TagCompilers.normalizeTagName(tagName))) {
            throw new IllegalStateException("MDX handler for tag " + tagName + " is already registered");
        }
        handlers.put(tagName, handler);
    }

    public static TagCompiler get(String tagName) {
        return handlers.get(TagCompilers.normalizeTagName(tagName));
    }

    public static void remove(String tagName) {
        handlers.remove(TagCompilers.normalizeTagName(tagName));
    }

    private static String normalizeTagName(String tagName) {
        return tagName.toLowerCase(Locale.ROOT);
    }

    static {
        TagCompilers.register("div", new DivTagCompiler());
        TagCompilers.register("a", new ATagCompiler());
        TagCompilers.register("ItemLink", new ItemLinkCompiler());
        TagCompilers.register("FloatingImage", new FloatingImageCompiler());
        TagCompilers.register("br", new BreakCompiler());
        TagCompilers.register("RecipeFor", new RecipeForCompiler());
        TagCompilers.register("ItemGrid", new ItemGridCompiler());
        TagCompilers.register("CategoryIndex", new CategoryIndexCompiler());
    }
}

