/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

class ProcessingPatternEncoding {
    private static final String NBT_INPUTS = "in";
    private static final String NBT_OUTPUTS = "out";

    ProcessingPatternEncoding() {
    }

    public static GenericStack[] getProcessingInputs(CompoundTag nbt) {
        return ProcessingPatternEncoding.getMixedList(nbt, NBT_INPUTS, 81);
    }

    public static GenericStack[] getProcessingOutputs(CompoundTag nbt) {
        return ProcessingPatternEncoding.getMixedList(nbt, NBT_OUTPUTS, 27);
    }

    public static GenericStack[] getMixedList(CompoundTag nbt, String nbtKey, int maxSize) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        ListTag tag = nbt.m_128437_(nbtKey, 10);
        Preconditions.checkArgument((tag.size() <= maxSize ? 1 : 0) != 0, (Object)("Cannot use more than " + maxSize + " ingredients"));
        GenericStack[] result = new GenericStack[tag.size()];
        for (int x = 0; x < tag.size(); ++x) {
            CompoundTag entry = tag.m_128728_(x);
            if (entry.m_128456_()) continue;
            GenericStack stack = GenericStack.readTag(entry);
            if (stack == null) {
                throw new IllegalArgumentException("Pattern references missing stack: " + entry);
            }
            result[x] = stack;
        }
        return result;
    }

    public static void encodeProcessingPattern(CompoundTag tag, GenericStack[] sparseInputs, GenericStack[] sparseOutputs) {
        tag.m_128365_(NBT_INPUTS, (Tag)ProcessingPatternEncoding.encodeStackList(sparseInputs));
        tag.m_128365_(NBT_OUTPUTS, (Tag)ProcessingPatternEncoding.encodeStackList(sparseOutputs));
    }

    private static ListTag encodeStackList(GenericStack[] stacks) {
        ListTag tag = new ListTag();
        boolean foundStack = false;
        for (GenericStack stack : stacks) {
            tag.add((Object)GenericStack.writeTag(stack));
            if (stack == null || stack.amount() <= 0L) continue;
            foundStack = true;
        }
        Preconditions.checkArgument((boolean)foundStack, (Object)"List passed to pattern must contain at least one stack.");
        return tag;
    }
}

